using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Text;


using CMS.GlobalHelper;
using CMS.SettingsProvider;
using CMS.DataEngine;
using CMS.SiteProvider;
using CMS.CMSHelper;
using CMS.Scheduler;
using CMS.EventLog;



/// <summary>
/// CMSCustom methods
/// </summary>
public static class CMSCustom
{
    //culture for the {#productlist#} macro
    static string culture = "";

    /// <summary>
    /// Match evaluator for the string localization
    /// </summary>
    /// <param name="m">Regular expression match</param>
    private static string LocalizedStringMatch(System.Text.RegularExpressions.Match m)
    {
        string expression = m.Groups[1].ToString();

        return ResHelper.GetString(expression, culture);
    }
    
    
    /// <summary>
    /// Initializes the custom methods
    /// </summary>
    public static void Init()
    {
        MacroResolver.OnResolveCustomMacro += new MacroResolver.MacroHandler(ResolveCustomMacro);
        ClassHelper.OnGetCustomClass += new ClassHelper.GetClassEventHandler(GetCustomClass);
    }


    /// <summary>
    /// Custom macro handler
    /// </summary>
    /// <param name="sender">Sender (active macro resolver)</param>
    /// <param name="expression">Expression to resolve</param>
    /// <param name="match">Returns true if the macro matches (was resolved)</param>
    public static string ResolveCustomMacro(MacroResolver sender, string expression, out bool match)
    {
        match = false;
        string result = expression;

        

        // Add your custom macro evaluation
        /*
        switch (expression.ToLower())
        {
            case "someexpression":
                match = true;
                result = "Resolved expression";
                break;
        }
        */

        switch (expression.ToLower())
        {

            // Display a product list with strings localized according to the order culture by: {#productlist#}

            case "productlist":

                match = true;

                // Get shopping cart object from resolver 
                CMS.Ecommerce.ShoppingCartInfo cartObj = sender.SourceObject as CMS.Ecommerce.ShoppingCartInfo;

                bool renderDiscount = true;
                CMS.Ecommerce.CurrencyInfo currency = CMS.Ecommerce.CurrencyInfoProvider.GetCurrencyInfo(cartObj.ShoppingCartCurrencyID);
                StringBuilder sb = new StringBuilder();

                //Get ShoppingCartCulture
                culture = cartObj.ShoppingCartCulture;

                // Header
                sb.Append(" <table width=\"100%\" style=\"text-align: right\" cellspacing=\"0\" cellpadding=\"2\" class=\"productsList\">");
                sb.Append(" <thead><tr><th colspan=\"" + (5 + (renderDiscount ? 1 : 0)) + "\" class=\"headerBorder\">&nbsp;</th></tr><tr>");
                sb.Append("     <th style=\"text-align: left;padding-left:2px\">");
                sb.Append(ResHelper.GetString("InvoiceTemplate.SKUName", culture));
                sb.Append("     </th>");
                sb.Append("     <th>");
                sb.Append(ResHelper.GetString("InvoiceTemplate.SKUUnits", culture));
                sb.Append("     </th>");
                sb.Append("     <th>");
                sb.Append(ResHelper.GetString("InvoiceTemplate.SKUPrice", culture));
                sb.Append("     </th>");
                if (renderDiscount)
                {
                    sb.Append(" <th>");
                    sb.Append(ResHelper.GetString("InvoiceTemplate.UnitDiscount", culture));
                    sb.Append(" </th>");
                }
                sb.Append("     <th>");
                sb.Append(ResHelper.GetString("InvoiceTemplate.Tax", culture));
                sb.Append("     </th>");
                sb.Append("     <th>");
                sb.Append(ResHelper.GetString("InvoiceTemplate.Subtotal", culture));
                sb.Append("     </th>");
                sb.Append("</tr></thead><tbody>");

                double value = 0.0;

                DataTable dt = cartObj.ShoppingCartContentTable;

                // Add the items
                foreach (DataRow dr in dt.Rows)
                {
                    //Get SKUName
                    string name = ResHelper.RegExLocalize.Replace(Convert.ToString(DataHelper.GetDataRowValue(dr, "SKUName")), LocalizedStringMatch);

                    // If it is a product option
                    if (ValidationHelper.GetGuid(DataHelper.GetDataRowValue(dr, "CartItemParentGuid"), Guid.Empty) != Guid.Empty)
                    {
                        name = "&nbsp;&nbsp;- " + name;
                    }

                    sb.Append("<tr>");
                    sb.Append(" <td style=\"text-align: left\">");
                    sb.Append(name);
                    sb.Append(" </td>");
                    sb.Append(" <td>");
                    sb.Append(Convert.ToString(DataHelper.GetDataRowValue(dr, "SKUUnits")));
                    sb.Append(" </td>");
                    sb.Append(" <td>");
                    value = ValidationHelper.GetDouble(DataHelper.GetDataRowValue(dr, "SKUPrice"), 0);
                    sb.Append(CMS.Ecommerce.CurrencyInfoProvider.GetFormatedValue(value, currency));
                    sb.Append(" </td>");
                    if (renderDiscount)
                    {
                        sb.Append(" <td>");
                        value = ValidationHelper.GetDouble(DataHelper.GetDataRowValue(dr, "UnitDiscount"), 0);
                        sb.Append(CMS.Ecommerce.CurrencyInfoProvider.GetFormatedValue(value, currency));
                        sb.Append(" </td>");
                    }
                    sb.Append(" <td>");
                    value = ValidationHelper.GetDouble(DataHelper.GetDataRowValue(dr, "Tax"), 0);
                    sb.Append(CMS.Ecommerce.CurrencyInfoProvider.GetFormatedValue(value, currency));
                    sb.Append(" </td>");
                    sb.Append(" <td>");
                    value = ValidationHelper.GetDouble(DataHelper.GetDataRowValue(dr, "Subtotal"), 0);
                    sb.Append(CMS.Ecommerce.CurrencyInfoProvider.GetFormatedValue(value, currency));
                    sb.Append(" </td>");
                    sb.Append("</tr>");
                }
                sb.Append(" <tr>");
                sb.Append(" <td colspan=\"" + (5 + (renderDiscount ? 1 : 0)) + "\" class=\"bottomBorder\">&nbsp;");
                sb.Append(" </td>");
                sb.Append(" </tr>");
                sb.Append(" </tbody>");
                sb.Append("</table> \n");

                
                result = sb.ToString();
                
                //Decode HTML tags
                sender.AllowParameters = false;

                break;

        }




        return result;
    }


    /// <summary>
    /// Gets the custom class object based on the given class name. This handler is called when the assembly name is App_Code
    /// </summary>
    /// <param name="className">Class name</param>
    public static object GetCustomClass(string className)
    {
        // Provide your custom classes
        switch (className)
        {
            // Define the class MyTask implementing ITask and you can provide your scheduled tasks out of App_Code
            case "Custom.MyTask":
                return new MyTask();
        }

        return null;
    }


    /// <summary>
    /// Sample task class
    /// </summary>
    public class MyTask : ITask
    {
        /// <summary>
        /// Executes the task
        /// </summary>
        /// <param name="ti">Task info</param>
        public string Execute(TaskInfo ti)
        {
            EventLogProvider ev = new EventLogProvider();
            ev.LogEvent("I", DateTime.Now, "MyTask", "Execute", null, "This task was executed from '~/App_Code/Global/CMS/CMSCustom.cs'.");

            return null;
        }
    }
}
